// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the File Details.
 */
public class FileDetails implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The File Name.
     * The name of the file.
     */
    @SerializedName(value = "fileName", alternate = {"FileName"})
    @Expose
	@Nullable
    public String fileName;

    /**
     * The File Path.
     * The file path (location) of the file instance.
     */
    @SerializedName(value = "filePath", alternate = {"FilePath"})
    @Expose
	@Nullable
    public String filePath;

    /**
     * The File Publisher.
     * The publisher of the file.
     */
    @SerializedName(value = "filePublisher", alternate = {"FilePublisher"})
    @Expose
	@Nullable
    public String filePublisher;

    /**
     * The File Size.
     * The size of the file in bytes.
     */
    @SerializedName(value = "fileSize", alternate = {"FileSize"})
    @Expose
	@Nullable
    public Long fileSize;

    /**
     * The Issuer.
     * The certificate authority (CA) that issued the certificate.
     */
    @SerializedName(value = "issuer", alternate = {"Issuer"})
    @Expose
	@Nullable
    public String issuer;

    /**
     * The Sha1.
     * The Sha1 cryptographic hash of the file content.
     */
    @SerializedName(value = "sha1", alternate = {"Sha1"})
    @Expose
	@Nullable
    public String sha1;

    /**
     * The Sha256.
     * The Sha256 cryptographic hash of the file content.
     */
    @SerializedName(value = "sha256", alternate = {"Sha256"})
    @Expose
	@Nullable
    public String sha256;

    /**
     * The Signer.
     * The signer of the signed file.
     */
    @SerializedName(value = "signer", alternate = {"Signer"})
    @Expose
	@Nullable
    public String signer;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
