// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;

import com.microsoft.graph.security.models.ExportOptions;
import com.microsoft.graph.security.models.ExportFileStructure;
import java.util.EnumSet;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Query Export Parameter Set.
 */
public class EdiscoveryReviewSetQueryExportParameterSet {
    /**
     * The output Name.
     * 
     */
    @SerializedName(value = "outputName", alternate = {"OutputName"})
    @Expose
	@Nullable
    public String outputName;

    /**
     * The description.
     * 
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The export Options.
     * 
     */
    @SerializedName(value = "exportOptions", alternate = {"ExportOptions"})
    @Expose
	@Nullable
    public EnumSet<ExportOptions> exportOptions;

    /**
     * The export Structure.
     * 
     */
    @SerializedName(value = "exportStructure", alternate = {"ExportStructure"})
    @Expose
	@Nullable
    public ExportFileStructure exportStructure;


    /**
     * Instiaciates a new EdiscoveryReviewSetQueryExportParameterSet
     */
    public EdiscoveryReviewSetQueryExportParameterSet() {}
    /**
     * Instiaciates a new EdiscoveryReviewSetQueryExportParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected EdiscoveryReviewSetQueryExportParameterSet(@Nonnull final EdiscoveryReviewSetQueryExportParameterSetBuilder builder) {
        this.outputName = builder.outputName;
        this.description = builder.description;
        this.exportOptions = builder.exportOptions;
        this.exportStructure = builder.exportStructure;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static EdiscoveryReviewSetQueryExportParameterSetBuilder newBuilder() {
        return new EdiscoveryReviewSetQueryExportParameterSetBuilder();
    }
    /**
     * Fluent builder for the EdiscoveryReviewSetQueryExportParameterSet
     */
    public static final class EdiscoveryReviewSetQueryExportParameterSetBuilder {
        /**
         * The outputName parameter value
         */
        @Nullable
        protected String outputName;
        /**
         * Sets the OutputName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryExportParameterSetBuilder withOutputName(@Nullable final String val) {
            this.outputName = val;
            return this;
        }
        /**
         * The description parameter value
         */
        @Nullable
        protected String description;
        /**
         * Sets the Description
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryExportParameterSetBuilder withDescription(@Nullable final String val) {
            this.description = val;
            return this;
        }
        /**
         * The exportOptions parameter value
         */
        @Nullable
        protected EnumSet<ExportOptions> exportOptions;
        /**
         * Sets the ExportOptions
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryExportParameterSetBuilder withExportOptions(@Nullable final EnumSet<ExportOptions> val) {
            this.exportOptions = val;
            return this;
        }
        /**
         * The exportStructure parameter value
         */
        @Nullable
        protected ExportFileStructure exportStructure;
        /**
         * Sets the ExportStructure
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetQueryExportParameterSetBuilder withExportStructure(@Nullable final ExportFileStructure val) {
            this.exportStructure = val;
            return this;
        }
        /**
         * Instanciates a new EdiscoveryReviewSetQueryExportParameterSetBuilder
         */
        @Nullable
        protected EdiscoveryReviewSetQueryExportParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public EdiscoveryReviewSetQueryExportParameterSet build() {
            return new EdiscoveryReviewSetQueryExportParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.outputName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("outputName", outputName));
        }
        if(this.description != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("description", description));
        }
        if(this.exportOptions != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("exportOptions", exportOptions));
        }
        if(this.exportStructure != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("exportStructure", exportStructure));
        }
        return result;
    }
}
