// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.WhoisRecord;
import com.microsoft.graph.security.models.WhoisHistoryRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionResponse;
import com.microsoft.graph.security.models.WhoisHistoryRecord;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Whois History Record Collection With References Page.
 */
public class WhoisHistoryRecordCollectionWithReferencesPage extends BaseCollectionPage<WhoisHistoryRecord, WhoisHistoryRecordCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for WhoisHistoryRecord
     *
     * @param response the serialized WhoisHistoryRecordCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public WhoisHistoryRecordCollectionWithReferencesPage(@Nonnull final WhoisHistoryRecordCollectionResponse response, @Nullable final WhoisHistoryRecordCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for WhoisHistoryRecord
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public WhoisHistoryRecordCollectionWithReferencesPage(@Nonnull final java.util.List<WhoisHistoryRecord> pageContents, @Nullable final WhoisHistoryRecordCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
