// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryReviewSet;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQuery;
import com.microsoft.graph.security.models.ExportOptions;
import com.microsoft.graph.security.models.ExportFileStructure;
import java.util.EnumSet;
import com.microsoft.graph.security.models.EdiscoveryReviewTag;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQueryExportParameterSet;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQueryApplyTagsParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Query Collection Request Builder.
 */
public class EdiscoveryReviewSetQueryCollectionRequestBuilder extends BaseCollectionRequestBuilder<EdiscoveryReviewSetQuery, EdiscoveryReviewSetQueryRequestBuilder, EdiscoveryReviewSetQueryCollectionResponse, EdiscoveryReviewSetQueryCollectionPage, EdiscoveryReviewSetQueryCollectionRequest> {

    /**
     * The request builder for this collection of EdiscoveryReviewSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryReviewSetQueryCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryReviewSetQueryRequestBuilder.class, EdiscoveryReviewSetQueryCollectionRequest.class);
    }



    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
