// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookWorksheet;
import com.microsoft.graph.models.WorkbookRange;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.WorkbookWorksheetCellParameterSet;
import com.microsoft.graph.models.WorkbookWorksheetUsedRangeParameterSet;
import com.microsoft.graph.models.WorkbookWorksheetRangeParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Request Builder.
 */
public class WorkbookWorksheetRequestBuilder extends BaseRequestBuilder<WorkbookWorksheet> {

    /**
     * The request builder for the WorkbookWorksheet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookWorksheetRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the WorkbookWorksheetRequest instance
     */
    @Nonnull
    public WorkbookWorksheetRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the WorkbookWorksheetRequest instance
     */
    @Nonnull
    public WorkbookWorksheetRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.WorkbookWorksheetRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the WorkbookChart collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookChartCollectionRequestBuilder charts() {
        return new com.microsoft.graph.requests.WorkbookChartCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("charts"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookChart item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookChartRequestBuilder charts(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WorkbookChartRequestBuilder(getRequestUrlWithAdditionalSegment("charts") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookNamedItem collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookNamedItemCollectionRequestBuilder names() {
        return new com.microsoft.graph.requests.WorkbookNamedItemCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("names"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookNamedItem item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookNamedItemRequestBuilder names(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WorkbookNamedItemRequestBuilder(getRequestUrlWithAdditionalSegment("names") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookPivotTable collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookPivotTableCollectionRequestBuilder pivotTables() {
        return new com.microsoft.graph.requests.WorkbookPivotTableCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("pivotTables"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookPivotTable item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookPivotTableRequestBuilder pivotTables(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WorkbookPivotTableRequestBuilder(getRequestUrlWithAdditionalSegment("pivotTables") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookWorksheetProtection
     *
     * @return the WorkbookWorksheetProtectionRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookWorksheetProtectionRequestBuilder protection() {
        return new com.microsoft.graph.requests.WorkbookWorksheetProtectionRequestBuilder(getRequestUrlWithAdditionalSegment("protection"), getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookTable collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookTableCollectionRequestBuilder tables() {
        return new com.microsoft.graph.requests.WorkbookTableCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tables"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookTable item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WorkbookTableRequestBuilder tables(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WorkbookTableRequestBuilder(getRequestUrlWithAdditionalSegment("tables") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookWorksheetCellRequestBuilder cell(@Nonnull final WorkbookWorksheetCellParameterSet parameters) {
        return new WorkbookWorksheetCellRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cell"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookWorksheetUsedRangeRequestBuilder usedRange() {
        return new WorkbookWorksheetUsedRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.usedRange"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookWorksheetUsedRangeRequestBuilder usedRange(@Nonnull final WorkbookWorksheetUsedRangeParameterSet parameters) {
        return new WorkbookWorksheetUsedRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.usedRange"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookWorksheetRangeRequestBuilder range() {
        return new WorkbookWorksheetRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.range"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookWorksheetRangeRequestBuilder range(@Nonnull final WorkbookWorksheetRangeParameterSet parameters) {
        return new WorkbookWorksheetRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.range"), getClient(), null, parameters);
    }
}
