// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsMicrosoftEdgeApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Microsoft Edge App Request.
 */
public class WindowsMicrosoftEdgeAppRequest extends BaseRequest<WindowsMicrosoftEdgeApp> {
	
    /**
     * The request for the WindowsMicrosoftEdgeApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsMicrosoftEdgeAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsMicrosoftEdgeApp.class);
    }

    /**
     * Gets the WindowsMicrosoftEdgeApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMicrosoftEdgeApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsMicrosoftEdgeApp from the service
     *
     * @return the WindowsMicrosoftEdgeApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMicrosoftEdgeApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMicrosoftEdgeApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsMicrosoftEdgeApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsMicrosoftEdgeApp with a source
     *
     * @param sourceWindowsMicrosoftEdgeApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMicrosoftEdgeApp> patchAsync(@Nonnull final WindowsMicrosoftEdgeApp sourceWindowsMicrosoftEdgeApp) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsMicrosoftEdgeApp);
    }

    /**
     * Patches this WindowsMicrosoftEdgeApp with a source
     *
     * @param sourceWindowsMicrosoftEdgeApp the source object with updates
     * @return the updated WindowsMicrosoftEdgeApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMicrosoftEdgeApp patch(@Nonnull final WindowsMicrosoftEdgeApp sourceWindowsMicrosoftEdgeApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsMicrosoftEdgeApp);
    }

    /**
     * Creates a WindowsMicrosoftEdgeApp with a new object
     *
     * @param newWindowsMicrosoftEdgeApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMicrosoftEdgeApp> postAsync(@Nonnull final WindowsMicrosoftEdgeApp newWindowsMicrosoftEdgeApp) {
        return sendAsync(HttpMethod.POST, newWindowsMicrosoftEdgeApp);
    }

    /**
     * Creates a WindowsMicrosoftEdgeApp with a new object
     *
     * @param newWindowsMicrosoftEdgeApp the new object to create
     * @return the created WindowsMicrosoftEdgeApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMicrosoftEdgeApp post(@Nonnull final WindowsMicrosoftEdgeApp newWindowsMicrosoftEdgeApp) throws ClientException {
        return send(HttpMethod.POST, newWindowsMicrosoftEdgeApp);
    }

    /**
     * Creates a WindowsMicrosoftEdgeApp with a new object
     *
     * @param newWindowsMicrosoftEdgeApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMicrosoftEdgeApp> putAsync(@Nonnull final WindowsMicrosoftEdgeApp newWindowsMicrosoftEdgeApp) {
        return sendAsync(HttpMethod.PUT, newWindowsMicrosoftEdgeApp);
    }

    /**
     * Creates a WindowsMicrosoftEdgeApp with a new object
     *
     * @param newWindowsMicrosoftEdgeApp the object to create/update
     * @return the created WindowsMicrosoftEdgeApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMicrosoftEdgeApp put(@Nonnull final WindowsMicrosoftEdgeApp newWindowsMicrosoftEdgeApp) throws ClientException {
        return send(HttpMethod.PUT, newWindowsMicrosoftEdgeApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMicrosoftEdgeAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMicrosoftEdgeAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

