// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventWebinar;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar Request Builder.
 */
public class VirtualEventWebinarRequestBuilder extends BaseRequestBuilder<VirtualEventWebinar> {

    /**
     * The request builder for the VirtualEventWebinar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventWebinarRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the VirtualEventWebinarRequest instance
     */
    @Nonnull
    public VirtualEventWebinarRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the VirtualEventWebinarRequest instance
     */
    @Nonnull
    public VirtualEventWebinarRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.VirtualEventWebinarRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the VirtualEventSession collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.VirtualEventSessionCollectionRequestBuilder sessions() {
        return new com.microsoft.graph.requests.VirtualEventSessionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sessions"), getClient(), null);
    }

    /**
     * Gets a request builder for the VirtualEventSession item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.VirtualEventSessionRequestBuilder sessions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.VirtualEventSessionRequestBuilder(getRequestUrlWithAdditionalSegment("sessions") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the VirtualEventRegistration collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.VirtualEventRegistrationCollectionRequestBuilder registrations() {
        return new com.microsoft.graph.requests.VirtualEventRegistrationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("registrations"), getClient(), null);
    }

    /**
     * Gets a request builder for the VirtualEventRegistration item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.VirtualEventRegistrationRequestBuilder registrations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.VirtualEventRegistrationRequestBuilder(getRequestUrlWithAdditionalSegment("registrations") + "/" + id, getClient(), null);
    }
}
