// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventWebinar;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.VirtualEventWebinarGetByUserRoleCollectionRequestBuilder;
import com.microsoft.graph.requests.VirtualEventWebinarGetByUserRoleCollectionRequest;
import com.microsoft.graph.requests.VirtualEventWebinarGetByUserRoleCollectionResponse;
import com.microsoft.graph.models.VirtualEventWebinarGetByUserRoleParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar Get By User Role Collection Request Builder.
 */
public class VirtualEventWebinarGetByUserRoleCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<VirtualEventWebinar, VirtualEventWebinarGetByUserRoleCollectionRequestBuilder, VirtualEventWebinarGetByUserRoleCollectionResponse, VirtualEventWebinarGetByUserRoleCollectionPage, VirtualEventWebinarGetByUserRoleCollectionRequest> {

    /**
     * The request builder for this collection of VirtualEventWebinar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventWebinarGetByUserRoleCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventWebinarGetByUserRoleCollectionRequestBuilder.class, VirtualEventWebinarGetByUserRoleCollectionRequest.class);
    }
    /**
     * The request builder for this collection of VirtualEventWebinar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public VirtualEventWebinarGetByUserRoleCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final VirtualEventWebinarGetByUserRoleParameterSet parameters) {
        super(requestUrl, client, requestOptions, VirtualEventWebinarGetByUserRoleCollectionRequestBuilder.class, VirtualEventWebinarGetByUserRoleCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the VirtualEventWebinarGetByUserRoleCollectionRequest instance
     */
    @Override
    @Nonnull
    public VirtualEventWebinarGetByUserRoleCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final VirtualEventWebinarGetByUserRoleCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
