// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Session Request.
 */
public class VirtualEventSessionRequest extends BaseRequest<VirtualEventSession> {
	
    /**
     * The request for the VirtualEventSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventSessionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventSession.class);
    }

    /**
     * Gets the VirtualEventSession from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventSession> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VirtualEventSession from the service
     *
     * @return the VirtualEventSession from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventSession get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventSession> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VirtualEventSession delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VirtualEventSession with a source
     *
     * @param sourceVirtualEventSession the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventSession> patchAsync(@Nonnull final VirtualEventSession sourceVirtualEventSession) {
        return sendAsync(HttpMethod.PATCH, sourceVirtualEventSession);
    }

    /**
     * Patches this VirtualEventSession with a source
     *
     * @param sourceVirtualEventSession the source object with updates
     * @return the updated VirtualEventSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventSession patch(@Nonnull final VirtualEventSession sourceVirtualEventSession) throws ClientException {
        return send(HttpMethod.PATCH, sourceVirtualEventSession);
    }

    /**
     * Creates a VirtualEventSession with a new object
     *
     * @param newVirtualEventSession the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventSession> postAsync(@Nonnull final VirtualEventSession newVirtualEventSession) {
        return sendAsync(HttpMethod.POST, newVirtualEventSession);
    }

    /**
     * Creates a VirtualEventSession with a new object
     *
     * @param newVirtualEventSession the new object to create
     * @return the created VirtualEventSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventSession post(@Nonnull final VirtualEventSession newVirtualEventSession) throws ClientException {
        return send(HttpMethod.POST, newVirtualEventSession);
    }

    /**
     * Creates a VirtualEventSession with a new object
     *
     * @param newVirtualEventSession the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventSession> putAsync(@Nonnull final VirtualEventSession newVirtualEventSession) {
        return sendAsync(HttpMethod.PUT, newVirtualEventSession);
    }

    /**
     * Creates a VirtualEventSession with a new object
     *
     * @param newVirtualEventSession the object to create/update
     * @return the created VirtualEventSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventSession put(@Nonnull final VirtualEventSession newVirtualEventSession) throws ClientException {
        return send(HttpMethod.PUT, newVirtualEventSession);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventSessionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventSessionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

