// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserSignInInsight;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Sign In Insight Request.
 */
public class UserSignInInsightRequest extends BaseRequest<UserSignInInsight> {
	
    /**
     * The request for the UserSignInInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserSignInInsightRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserSignInInsight.class);
    }

    /**
     * Gets the UserSignInInsight from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSignInInsight> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserSignInInsight from the service
     *
     * @return the UserSignInInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSignInInsight get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSignInInsight> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserSignInInsight delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserSignInInsight with a source
     *
     * @param sourceUserSignInInsight the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSignInInsight> patchAsync(@Nonnull final UserSignInInsight sourceUserSignInInsight) {
        return sendAsync(HttpMethod.PATCH, sourceUserSignInInsight);
    }

    /**
     * Patches this UserSignInInsight with a source
     *
     * @param sourceUserSignInInsight the source object with updates
     * @return the updated UserSignInInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSignInInsight patch(@Nonnull final UserSignInInsight sourceUserSignInInsight) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserSignInInsight);
    }

    /**
     * Creates a UserSignInInsight with a new object
     *
     * @param newUserSignInInsight the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSignInInsight> postAsync(@Nonnull final UserSignInInsight newUserSignInInsight) {
        return sendAsync(HttpMethod.POST, newUserSignInInsight);
    }

    /**
     * Creates a UserSignInInsight with a new object
     *
     * @param newUserSignInInsight the new object to create
     * @return the created UserSignInInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSignInInsight post(@Nonnull final UserSignInInsight newUserSignInInsight) throws ClientException {
        return send(HttpMethod.POST, newUserSignInInsight);
    }

    /**
     * Creates a UserSignInInsight with a new object
     *
     * @param newUserSignInInsight the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSignInInsight> putAsync(@Nonnull final UserSignInInsight newUserSignInInsight) {
        return sendAsync(HttpMethod.PUT, newUserSignInInsight);
    }

    /**
     * Creates a UserSignInInsight with a new object
     *
     * @param newUserSignInInsight the object to create/update
     * @return the created UserSignInInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSignInInsight put(@Nonnull final UserSignInInsight newUserSignInInsight) throws ClientException {
        return send(HttpMethod.PUT, newUserSignInInsight);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserSignInInsightRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserSignInInsightRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

