// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.UserExportDeviceAndAppManagementDataRequest;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.DeviceAndAppManagementData;
import com.microsoft.graph.models.DeviceAndAppManagementData;
import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.models.UserExportDeviceAndAppManagementDataParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Export Device And App Management Data Request Builder.
 */
public class UserExportDeviceAndAppManagementDataRequestBuilder extends BaseFunctionRequestBuilder<DeviceAndAppManagementData> {

    /**
     * The request builder for this UserExportDeviceAndAppManagementData
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExportDeviceAndAppManagementDataRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    /**
     * The request builder for this UserExportDeviceAndAppManagementData
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public UserExportDeviceAndAppManagementDataRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final UserExportDeviceAndAppManagementDataParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }

    /**
     * Creates the UserExportDeviceAndAppManagementDataRequest
     *
     * @param requestOptions the options for the request
     * @return the UserExportDeviceAndAppManagementDataRequest instance
     */
    @Nonnull
    public UserExportDeviceAndAppManagementDataRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the UserExportDeviceAndAppManagementDataRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the UserExportDeviceAndAppManagementDataRequest instance
     */
    @Nonnull
    public UserExportDeviceAndAppManagementDataRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UserExportDeviceAndAppManagementDataRequest request = new UserExportDeviceAndAppManagementDataRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
        }
        return request;
    }
}
