// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsAppHealthDeviceModelPerformance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics App Health Device Model Performance Request.
 */
public class UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest extends BaseRequest<UserExperienceAnalyticsAppHealthDeviceModelPerformance> {
	
    /**
     * The request for the UserExperienceAnalyticsAppHealthDeviceModelPerformance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsAppHealthDeviceModelPerformance.class);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthDeviceModelPerformance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDeviceModelPerformance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthDeviceModelPerformance from the service
     *
     * @return the UserExperienceAnalyticsAppHealthDeviceModelPerformance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDeviceModelPerformance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthDeviceModelPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDeviceModelPerformance> patchAsync(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthDeviceModelPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance the source object with updates
     * @return the updated UserExperienceAnalyticsAppHealthDeviceModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance patch(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDeviceModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDeviceModelPerformance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDeviceModelPerformance> postAsync(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance newUserExperienceAnalyticsAppHealthDeviceModelPerformance) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDeviceModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDeviceModelPerformance the new object to create
     * @return the created UserExperienceAnalyticsAppHealthDeviceModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance post(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance newUserExperienceAnalyticsAppHealthDeviceModelPerformance) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDeviceModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDeviceModelPerformance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDeviceModelPerformance> putAsync(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance newUserExperienceAnalyticsAppHealthDeviceModelPerformance) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDeviceModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDeviceModelPerformance the object to create/update
     * @return the created UserExperienceAnalyticsAppHealthDeviceModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance put(@Nonnull final UserExperienceAnalyticsAppHealthDeviceModelPerformance newUserExperienceAnalyticsAppHealthDeviceModelPerformance) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthDeviceModelPerformance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

