// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics App Health App Performance By App Version Details Request.
 */
public class UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest extends BaseRequest<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> {
	
    /**
     * The request for the UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails.class);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails from the service
     *
     * @return the UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> patchAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the source object with updates
     * @return the updated UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails patch(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> postAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the new object to create
     * @return the created UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails post(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> putAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails the object to create/update
     * @return the created UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails put(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

