// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleRequest;
import com.microsoft.graph.models.RoleAssignmentScheduleRequestFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment Schedule Request Request.
 */
public class UnifiedRoleAssignmentScheduleRequestRequest extends BaseRequest<UnifiedRoleAssignmentScheduleRequest> {
	
    /**
     * The request for the UnifiedRoleAssignmentScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleAssignmentScheduleRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleAssignmentScheduleRequest.class);
    }

    /**
     * Gets the UnifiedRoleAssignmentScheduleRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleAssignmentScheduleRequest from the service
     *
     * @return the UnifiedRoleAssignmentScheduleRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleAssignmentScheduleRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleAssignmentScheduleRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleAssignmentScheduleRequest with a source
     *
     * @param sourceUnifiedRoleAssignmentScheduleRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleRequest> patchAsync(@Nonnull final UnifiedRoleAssignmentScheduleRequest sourceUnifiedRoleAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Patches this UnifiedRoleAssignmentScheduleRequest with a source
     *
     * @param sourceUnifiedRoleAssignmentScheduleRequest the source object with updates
     * @return the updated UnifiedRoleAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleAssignmentScheduleRequest patch(@Nonnull final UnifiedRoleAssignmentScheduleRequest sourceUnifiedRoleAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleAssignmentScheduleRequest with a new object
     *
     * @param newUnifiedRoleAssignmentScheduleRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleRequest> postAsync(@Nonnull final UnifiedRoleAssignmentScheduleRequest newUnifiedRoleAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleAssignmentScheduleRequest with a new object
     *
     * @param newUnifiedRoleAssignmentScheduleRequest the new object to create
     * @return the created UnifiedRoleAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleAssignmentScheduleRequest post(@Nonnull final UnifiedRoleAssignmentScheduleRequest newUnifiedRoleAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleAssignmentScheduleRequest with a new object
     *
     * @param newUnifiedRoleAssignmentScheduleRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleRequest> putAsync(@Nonnull final UnifiedRoleAssignmentScheduleRequest newUnifiedRoleAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleAssignmentScheduleRequest with a new object
     *
     * @param newUnifiedRoleAssignmentScheduleRequest the object to create/update
     * @return the created UnifiedRoleAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleAssignmentScheduleRequest put(@Nonnull final UnifiedRoleAssignmentScheduleRequest newUnifiedRoleAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleAssignmentScheduleRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleAssignmentScheduleRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleAssignmentScheduleRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

