// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TrainingLanguageDetail;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Training Language Detail Request.
 */
public class TrainingLanguageDetailRequest extends BaseRequest<TrainingLanguageDetail> {
	
    /**
     * The request for the TrainingLanguageDetail
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TrainingLanguageDetailRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TrainingLanguageDetail.class);
    }

    /**
     * Gets the TrainingLanguageDetail from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TrainingLanguageDetail> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TrainingLanguageDetail from the service
     *
     * @return the TrainingLanguageDetail from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TrainingLanguageDetail get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TrainingLanguageDetail> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TrainingLanguageDetail delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TrainingLanguageDetail with a source
     *
     * @param sourceTrainingLanguageDetail the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TrainingLanguageDetail> patchAsync(@Nonnull final TrainingLanguageDetail sourceTrainingLanguageDetail) {
        return sendAsync(HttpMethod.PATCH, sourceTrainingLanguageDetail);
    }

    /**
     * Patches this TrainingLanguageDetail with a source
     *
     * @param sourceTrainingLanguageDetail the source object with updates
     * @return the updated TrainingLanguageDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TrainingLanguageDetail patch(@Nonnull final TrainingLanguageDetail sourceTrainingLanguageDetail) throws ClientException {
        return send(HttpMethod.PATCH, sourceTrainingLanguageDetail);
    }

    /**
     * Creates a TrainingLanguageDetail with a new object
     *
     * @param newTrainingLanguageDetail the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TrainingLanguageDetail> postAsync(@Nonnull final TrainingLanguageDetail newTrainingLanguageDetail) {
        return sendAsync(HttpMethod.POST, newTrainingLanguageDetail);
    }

    /**
     * Creates a TrainingLanguageDetail with a new object
     *
     * @param newTrainingLanguageDetail the new object to create
     * @return the created TrainingLanguageDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TrainingLanguageDetail post(@Nonnull final TrainingLanguageDetail newTrainingLanguageDetail) throws ClientException {
        return send(HttpMethod.POST, newTrainingLanguageDetail);
    }

    /**
     * Creates a TrainingLanguageDetail with a new object
     *
     * @param newTrainingLanguageDetail the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TrainingLanguageDetail> putAsync(@Nonnull final TrainingLanguageDetail newTrainingLanguageDetail) {
        return sendAsync(HttpMethod.PUT, newTrainingLanguageDetail);
    }

    /**
     * Creates a TrainingLanguageDetail with a new object
     *
     * @param newTrainingLanguageDetail the object to create/update
     * @return the created TrainingLanguageDetail
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TrainingLanguageDetail put(@Nonnull final TrainingLanguageDetail newTrainingLanguageDetail) throws ClientException {
        return send(HttpMethod.PUT, newTrainingLanguageDetail);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TrainingLanguageDetailRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TrainingLanguageDetailRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

