// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TargetDeviceGroup;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Target Device Group Request.
 */
public class TargetDeviceGroupRequest extends BaseRequest<TargetDeviceGroup> {
	
    /**
     * The request for the TargetDeviceGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TargetDeviceGroupRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TargetDeviceGroup.class);
    }

    /**
     * Gets the TargetDeviceGroup from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TargetDeviceGroup> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TargetDeviceGroup from the service
     *
     * @return the TargetDeviceGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TargetDeviceGroup get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TargetDeviceGroup> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TargetDeviceGroup delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TargetDeviceGroup with a source
     *
     * @param sourceTargetDeviceGroup the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TargetDeviceGroup> patchAsync(@Nonnull final TargetDeviceGroup sourceTargetDeviceGroup) {
        return sendAsync(HttpMethod.PATCH, sourceTargetDeviceGroup);
    }

    /**
     * Patches this TargetDeviceGroup with a source
     *
     * @param sourceTargetDeviceGroup the source object with updates
     * @return the updated TargetDeviceGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TargetDeviceGroup patch(@Nonnull final TargetDeviceGroup sourceTargetDeviceGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourceTargetDeviceGroup);
    }

    /**
     * Creates a TargetDeviceGroup with a new object
     *
     * @param newTargetDeviceGroup the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TargetDeviceGroup> postAsync(@Nonnull final TargetDeviceGroup newTargetDeviceGroup) {
        return sendAsync(HttpMethod.POST, newTargetDeviceGroup);
    }

    /**
     * Creates a TargetDeviceGroup with a new object
     *
     * @param newTargetDeviceGroup the new object to create
     * @return the created TargetDeviceGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TargetDeviceGroup post(@Nonnull final TargetDeviceGroup newTargetDeviceGroup) throws ClientException {
        return send(HttpMethod.POST, newTargetDeviceGroup);
    }

    /**
     * Creates a TargetDeviceGroup with a new object
     *
     * @param newTargetDeviceGroup the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TargetDeviceGroup> putAsync(@Nonnull final TargetDeviceGroup newTargetDeviceGroup) {
        return sendAsync(HttpMethod.PUT, newTargetDeviceGroup);
    }

    /**
     * Creates a TargetDeviceGroup with a new object
     *
     * @param newTargetDeviceGroup the object to create/update
     * @return the created TargetDeviceGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TargetDeviceGroup put(@Nonnull final TargetDeviceGroup newTargetDeviceGroup) throws ClientException {
        return send(HttpMethod.PUT, newTargetDeviceGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TargetDeviceGroupRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TargetDeviceGroupRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

