// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SkypeForBusinessUserConversationMember;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.ActionResultPart;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Skype For Business User Conversation Member Request.
 */
public class SkypeForBusinessUserConversationMemberRequest extends BaseRequest<SkypeForBusinessUserConversationMember> {
	
    /**
     * The request for the SkypeForBusinessUserConversationMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SkypeForBusinessUserConversationMemberRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SkypeForBusinessUserConversationMember.class);
    }

    /**
     * Gets the SkypeForBusinessUserConversationMember from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SkypeForBusinessUserConversationMember> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SkypeForBusinessUserConversationMember from the service
     *
     * @return the SkypeForBusinessUserConversationMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SkypeForBusinessUserConversationMember get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SkypeForBusinessUserConversationMember> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SkypeForBusinessUserConversationMember delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SkypeForBusinessUserConversationMember with a source
     *
     * @param sourceSkypeForBusinessUserConversationMember the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SkypeForBusinessUserConversationMember> patchAsync(@Nonnull final SkypeForBusinessUserConversationMember sourceSkypeForBusinessUserConversationMember) {
        return sendAsync(HttpMethod.PATCH, sourceSkypeForBusinessUserConversationMember);
    }

    /**
     * Patches this SkypeForBusinessUserConversationMember with a source
     *
     * @param sourceSkypeForBusinessUserConversationMember the source object with updates
     * @return the updated SkypeForBusinessUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SkypeForBusinessUserConversationMember patch(@Nonnull final SkypeForBusinessUserConversationMember sourceSkypeForBusinessUserConversationMember) throws ClientException {
        return send(HttpMethod.PATCH, sourceSkypeForBusinessUserConversationMember);
    }

    /**
     * Creates a SkypeForBusinessUserConversationMember with a new object
     *
     * @param newSkypeForBusinessUserConversationMember the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SkypeForBusinessUserConversationMember> postAsync(@Nonnull final SkypeForBusinessUserConversationMember newSkypeForBusinessUserConversationMember) {
        return sendAsync(HttpMethod.POST, newSkypeForBusinessUserConversationMember);
    }

    /**
     * Creates a SkypeForBusinessUserConversationMember with a new object
     *
     * @param newSkypeForBusinessUserConversationMember the new object to create
     * @return the created SkypeForBusinessUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SkypeForBusinessUserConversationMember post(@Nonnull final SkypeForBusinessUserConversationMember newSkypeForBusinessUserConversationMember) throws ClientException {
        return send(HttpMethod.POST, newSkypeForBusinessUserConversationMember);
    }

    /**
     * Creates a SkypeForBusinessUserConversationMember with a new object
     *
     * @param newSkypeForBusinessUserConversationMember the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SkypeForBusinessUserConversationMember> putAsync(@Nonnull final SkypeForBusinessUserConversationMember newSkypeForBusinessUserConversationMember) {
        return sendAsync(HttpMethod.PUT, newSkypeForBusinessUserConversationMember);
    }

    /**
     * Creates a SkypeForBusinessUserConversationMember with a new object
     *
     * @param newSkypeForBusinessUserConversationMember the object to create/update
     * @return the created SkypeForBusinessUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SkypeForBusinessUserConversationMember put(@Nonnull final SkypeForBusinessUserConversationMember newSkypeForBusinessUserConversationMember) throws ClientException {
        return send(HttpMethod.PUT, newSkypeForBusinessUserConversationMember);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SkypeForBusinessUserConversationMemberRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SkypeForBusinessUserConversationMemberRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

