// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RiskyServicePrincipalHistoryItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal History Item Request.
 */
public class RiskyServicePrincipalHistoryItemRequest extends BaseRequest<RiskyServicePrincipalHistoryItem> {
	
    /**
     * The request for the RiskyServicePrincipalHistoryItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskyServicePrincipalHistoryItemRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskyServicePrincipalHistoryItem.class);
    }

    /**
     * Gets the RiskyServicePrincipalHistoryItem from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipalHistoryItem> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RiskyServicePrincipalHistoryItem from the service
     *
     * @return the RiskyServicePrincipalHistoryItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipalHistoryItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipalHistoryItem> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RiskyServicePrincipalHistoryItem delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RiskyServicePrincipalHistoryItem with a source
     *
     * @param sourceRiskyServicePrincipalHistoryItem the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipalHistoryItem> patchAsync(@Nonnull final RiskyServicePrincipalHistoryItem sourceRiskyServicePrincipalHistoryItem) {
        return sendAsync(HttpMethod.PATCH, sourceRiskyServicePrincipalHistoryItem);
    }

    /**
     * Patches this RiskyServicePrincipalHistoryItem with a source
     *
     * @param sourceRiskyServicePrincipalHistoryItem the source object with updates
     * @return the updated RiskyServicePrincipalHistoryItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipalHistoryItem patch(@Nonnull final RiskyServicePrincipalHistoryItem sourceRiskyServicePrincipalHistoryItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceRiskyServicePrincipalHistoryItem);
    }

    /**
     * Creates a RiskyServicePrincipalHistoryItem with a new object
     *
     * @param newRiskyServicePrincipalHistoryItem the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipalHistoryItem> postAsync(@Nonnull final RiskyServicePrincipalHistoryItem newRiskyServicePrincipalHistoryItem) {
        return sendAsync(HttpMethod.POST, newRiskyServicePrincipalHistoryItem);
    }

    /**
     * Creates a RiskyServicePrincipalHistoryItem with a new object
     *
     * @param newRiskyServicePrincipalHistoryItem the new object to create
     * @return the created RiskyServicePrincipalHistoryItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipalHistoryItem post(@Nonnull final RiskyServicePrincipalHistoryItem newRiskyServicePrincipalHistoryItem) throws ClientException {
        return send(HttpMethod.POST, newRiskyServicePrincipalHistoryItem);
    }

    /**
     * Creates a RiskyServicePrincipalHistoryItem with a new object
     *
     * @param newRiskyServicePrincipalHistoryItem the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipalHistoryItem> putAsync(@Nonnull final RiskyServicePrincipalHistoryItem newRiskyServicePrincipalHistoryItem) {
        return sendAsync(HttpMethod.PUT, newRiskyServicePrincipalHistoryItem);
    }

    /**
     * Creates a RiskyServicePrincipalHistoryItem with a new object
     *
     * @param newRiskyServicePrincipalHistoryItem the object to create/update
     * @return the created RiskyServicePrincipalHistoryItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipalHistoryItem put(@Nonnull final RiskyServicePrincipalHistoryItem newRiskyServicePrincipalHistoryItem) throws ClientException {
        return send(HttpMethod.PUT, newRiskyServicePrincipalHistoryItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RiskyServicePrincipalHistoryItemRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RiskyServicePrincipalHistoryItemRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

