// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RemoteDesktopSecurityConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Desktop Security Configuration Request Builder.
 */
public class RemoteDesktopSecurityConfigurationRequestBuilder extends BaseRequestBuilder<RemoteDesktopSecurityConfiguration> {

    /**
     * The request builder for the RemoteDesktopSecurityConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteDesktopSecurityConfigurationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the RemoteDesktopSecurityConfigurationRequest instance
     */
    @Nonnull
    public RemoteDesktopSecurityConfigurationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the RemoteDesktopSecurityConfigurationRequest instance
     */
    @Nonnull
    public RemoteDesktopSecurityConfigurationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.RemoteDesktopSecurityConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the TargetDeviceGroup collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TargetDeviceGroupCollectionRequestBuilder targetDeviceGroups() {
        return new com.microsoft.graph.requests.TargetDeviceGroupCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("targetDeviceGroups"), getClient(), null);
    }

    /**
     * Gets a request builder for the TargetDeviceGroup item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TargetDeviceGroupRequestBuilder targetDeviceGroups(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TargetDeviceGroupRequestBuilder(getRequestUrlWithAdditionalSegment("targetDeviceGroups") + "/" + id, getClient(), null);
    }
}
