// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ProfileCardProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Profile Card Property Request.
 */
public class ProfileCardPropertyRequest extends BaseRequest<ProfileCardProperty> {
	
    /**
     * The request for the ProfileCardProperty
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ProfileCardPropertyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProfileCardProperty.class);
    }

    /**
     * Gets the ProfileCardProperty from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfileCardProperty> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ProfileCardProperty from the service
     *
     * @return the ProfileCardProperty from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfileCardProperty get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfileCardProperty> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ProfileCardProperty delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ProfileCardProperty with a source
     *
     * @param sourceProfileCardProperty the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfileCardProperty> patchAsync(@Nonnull final ProfileCardProperty sourceProfileCardProperty) {
        return sendAsync(HttpMethod.PATCH, sourceProfileCardProperty);
    }

    /**
     * Patches this ProfileCardProperty with a source
     *
     * @param sourceProfileCardProperty the source object with updates
     * @return the updated ProfileCardProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfileCardProperty patch(@Nonnull final ProfileCardProperty sourceProfileCardProperty) throws ClientException {
        return send(HttpMethod.PATCH, sourceProfileCardProperty);
    }

    /**
     * Creates a ProfileCardProperty with a new object
     *
     * @param newProfileCardProperty the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfileCardProperty> postAsync(@Nonnull final ProfileCardProperty newProfileCardProperty) {
        return sendAsync(HttpMethod.POST, newProfileCardProperty);
    }

    /**
     * Creates a ProfileCardProperty with a new object
     *
     * @param newProfileCardProperty the new object to create
     * @return the created ProfileCardProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfileCardProperty post(@Nonnull final ProfileCardProperty newProfileCardProperty) throws ClientException {
        return send(HttpMethod.POST, newProfileCardProperty);
    }

    /**
     * Creates a ProfileCardProperty with a new object
     *
     * @param newProfileCardProperty the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfileCardProperty> putAsync(@Nonnull final ProfileCardProperty newProfileCardProperty) {
        return sendAsync(HttpMethod.PUT, newProfileCardProperty);
    }

    /**
     * Creates a ProfileCardProperty with a new object
     *
     * @param newProfileCardProperty the object to create/update
     * @return the created ProfileCardProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfileCardProperty put(@Nonnull final ProfileCardProperty newProfileCardProperty) throws ClientException {
        return send(HttpMethod.PUT, newProfileCardProperty);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ProfileCardPropertyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ProfileCardPropertyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

