// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessScheduleRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Schedule Request Request.
 */
public class PrivilegedAccessScheduleRequestRequest extends BaseRequest<PrivilegedAccessScheduleRequest> {
	
    /**
     * The request for the PrivilegedAccessScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public PrivilegedAccessScheduleRequestRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends PrivilegedAccessScheduleRequest> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the PrivilegedAccessScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessScheduleRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessScheduleRequest.class);
    }

    /**
     * Gets the PrivilegedAccessScheduleRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessScheduleRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessScheduleRequest from the service
     *
     * @return the PrivilegedAccessScheduleRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessScheduleRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessScheduleRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessScheduleRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessScheduleRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessScheduleRequest> patchAsync(@Nonnull final PrivilegedAccessScheduleRequest sourcePrivilegedAccessScheduleRequest) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessScheduleRequest);
    }

    /**
     * Patches this PrivilegedAccessScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessScheduleRequest the source object with updates
     * @return the updated PrivilegedAccessScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessScheduleRequest patch(@Nonnull final PrivilegedAccessScheduleRequest sourcePrivilegedAccessScheduleRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessScheduleRequest with a new object
     *
     * @param newPrivilegedAccessScheduleRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessScheduleRequest> postAsync(@Nonnull final PrivilegedAccessScheduleRequest newPrivilegedAccessScheduleRequest) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessScheduleRequest with a new object
     *
     * @param newPrivilegedAccessScheduleRequest the new object to create
     * @return the created PrivilegedAccessScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessScheduleRequest post(@Nonnull final PrivilegedAccessScheduleRequest newPrivilegedAccessScheduleRequest) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessScheduleRequest with a new object
     *
     * @param newPrivilegedAccessScheduleRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessScheduleRequest> putAsync(@Nonnull final PrivilegedAccessScheduleRequest newPrivilegedAccessScheduleRequest) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessScheduleRequest with a new object
     *
     * @param newPrivilegedAccessScheduleRequest the object to create/update
     * @return the created PrivilegedAccessScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessScheduleRequest put(@Nonnull final PrivilegedAccessScheduleRequest newPrivilegedAccessScheduleRequest) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessScheduleRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessScheduleRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessScheduleRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

