// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequest;
import com.microsoft.graph.models.EligibilityScheduleRequestFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Request Request.
 */
public class PrivilegedAccessGroupEligibilityScheduleRequestRequest extends BaseRequest<PrivilegedAccessGroupEligibilityScheduleRequest> {
	
    /**
     * The request for the PrivilegedAccessGroupEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupEligibilityScheduleRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleRequest.class);
    }

    /**
     * Gets the PrivilegedAccessGroupEligibilityScheduleRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupEligibilityScheduleRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessGroupEligibilityScheduleRequest from the service
     *
     * @return the PrivilegedAccessGroupEligibilityScheduleRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupEligibilityScheduleRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupEligibilityScheduleRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessGroupEligibilityScheduleRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessGroupEligibilityScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessGroupEligibilityScheduleRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupEligibilityScheduleRequest> patchAsync(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest sourcePrivilegedAccessGroupEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Patches this PrivilegedAccessGroupEligibilityScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessGroupEligibilityScheduleRequest the source object with updates
     * @return the updated PrivilegedAccessGroupEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupEligibilityScheduleRequest patch(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest sourcePrivilegedAccessGroupEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupEligibilityScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupEligibilityScheduleRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupEligibilityScheduleRequest> postAsync(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest newPrivilegedAccessGroupEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupEligibilityScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupEligibilityScheduleRequest the new object to create
     * @return the created PrivilegedAccessGroupEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupEligibilityScheduleRequest post(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest newPrivilegedAccessGroupEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupEligibilityScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupEligibilityScheduleRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupEligibilityScheduleRequest> putAsync(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest newPrivilegedAccessGroupEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupEligibilityScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupEligibilityScheduleRequest the object to create/update
     * @return the created PrivilegedAccessGroupEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupEligibilityScheduleRequest put(@Nonnull final PrivilegedAccessGroupEligibilityScheduleRequest newPrivilegedAccessGroupEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessGroupEligibilityScheduleRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupEligibilityScheduleRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupEligibilityScheduleRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

