// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroup;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilitySchedule;
import com.microsoft.graph.models.EligibilityScheduleFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleCollectionRequestBuilder;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestBuilder;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleCollectionRequest;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Collection Request Builder.
 */
public class PrivilegedAccessGroupEligibilityScheduleCollectionRequestBuilder extends BaseCollectionRequestBuilder<PrivilegedAccessGroupEligibilitySchedule, PrivilegedAccessGroupEligibilityScheduleRequestBuilder, PrivilegedAccessGroupEligibilityScheduleCollectionResponse, PrivilegedAccessGroupEligibilityScheduleCollectionPage, PrivilegedAccessGroupEligibilityScheduleCollectionRequest> {

    /**
     * The request builder for this collection of PrivilegedAccessGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupEligibilityScheduleCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleRequestBuilder.class, PrivilegedAccessGroupEligibilityScheduleCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder filterByCurrentUser(@Nonnull final PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserParameterSet parameters) {
        return new PrivilegedAccessGroupEligibilityScheduleFilterByCurrentUserCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.filterByCurrentUser"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
