// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentScheduleRequest;
import com.microsoft.graph.models.AssignmentScheduleRequestFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Assignment Schedule Request Request Builder.
 */
public class PrivilegedAccessGroupAssignmentScheduleRequestRequestBuilder extends BaseRequestBuilder<PrivilegedAccessGroupAssignmentScheduleRequest> {

    /**
     * The request builder for the PrivilegedAccessGroupAssignmentScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupAssignmentScheduleRequestRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrivilegedAccessGroupAssignmentScheduleRequestRequest instance
     */
    @Nonnull
    public PrivilegedAccessGroupAssignmentScheduleRequestRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PrivilegedAccessGroupAssignmentScheduleRequestRequest instance
     */
    @Nonnull
    public PrivilegedAccessGroupAssignmentScheduleRequestRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleRequestRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for PrivilegedAccessGroupEligibilitySchedule
     *
     * @return the PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder activatedUsing() {
        return new com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("activatedUsing"), getClient(), null);
    }

    /**
     * Gets the request builder for Group
     *
     * @return the GroupWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupWithReferenceRequestBuilder group() {
        return new com.microsoft.graph.requests.GroupWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("group"), getClient(), null);
    }

    /**
     * Gets the request builder for DirectoryObject
     *
     * @return the DirectoryObjectWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder principal() {
        return new com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("principal"), getClient(), null);
    }

    /**
     * Gets the request builder for PrivilegedAccessGroupEligibilitySchedule
     *
     * @return the PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder targetSchedule() {
        return new com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("targetSchedule"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public PrivilegedAccessGroupAssignmentScheduleRequestCancelRequestBuilder cancel() {
        return new PrivilegedAccessGroupAssignmentScheduleRequestCancelRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), getClient(), null);
    }
}
