// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.OrgContactRetryServiceProvisioningRequest;
import com.microsoft.graph.models.OrgContact;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Org Contact Retry Service Provisioning Request Builder.
 */
public class OrgContactRetryServiceProvisioningRequestBuilder extends BaseActionRequestBuilder<OrgContact> {

    /**
     * The request builder for this OrgContactRetryServiceProvisioning
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrgContactRetryServiceProvisioningRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the OrgContactRetryServiceProvisioningRequest
     *
     * @param requestOptions the options for the request
     * @return the OrgContactRetryServiceProvisioningRequest instance
     */
    @Nonnull
    public OrgContactRetryServiceProvisioningRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the OrgContactRetryServiceProvisioningRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the OrgContactRetryServiceProvisioningRequest instance
     */
    @Nonnull
    public OrgContactRetryServiceProvisioningRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final OrgContactRetryServiceProvisioningRequest request = new OrgContactRetryServiceProvisioningRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
