// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnenotePage;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.OnenotePatchContentCommand;
import com.microsoft.graph.models.OnenotePagePreview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.OnenotePageCopyToSectionParameterSet;
import com.microsoft.graph.models.OnenotePageOnenotePatchContentParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Request Builder.
 */
public class OnenotePageRequestBuilder extends BaseRequestBuilder<OnenotePage> {

    /**
     * The request builder for the OnenotePage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenotePageRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the OnenotePageRequest instance
     */
    @Nonnull
    public OnenotePageRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the OnenotePageRequest instance
     */
    @Nonnull
    public OnenotePageRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.OnenotePageRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Notebook
     *
     * @return the NotebookRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.NotebookRequestBuilder parentNotebook() {
        return new com.microsoft.graph.requests.NotebookRequestBuilder(getRequestUrlWithAdditionalSegment("parentNotebook"), getClient(), null);
    }

    /**
     * Gets the request builder for OnenoteSection
     *
     * @return the OnenoteSectionRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.OnenoteSectionRequestBuilder parentSection() {
        return new com.microsoft.graph.requests.OnenoteSectionRequestBuilder(getRequestUrlWithAdditionalSegment("parentSection"), getClient(), null);
    }

    /**
     * Gets the request builder for content
     *
     * @return the OnenotePageContentStreamRequestBuilder instance
     */
    @Nonnull
    public OnenotePageContentStreamRequestBuilder content() {
        return new OnenotePageContentStreamRequestBuilder(getRequestUrlWithAdditionalSegment("content"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public OnenotePageCopyToSectionRequestBuilder copyToSection(@Nonnull final OnenotePageCopyToSectionParameterSet parameters) {
        return new OnenotePageCopyToSectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyToSection"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public OnenotePageOnenotePatchContentRequestBuilder onenotePatchContent(@Nonnull final OnenotePageOnenotePatchContentParameterSet parameters) {
        return new OnenotePageOnenotePatchContentRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.onenotePatchContent"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public OnenotePagePreviewRequestBuilder preview() {
        return new OnenotePagePreviewRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.preview"), getClient(), null);
    }
}
