// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Configuration Request.
 */
public class MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest extends BaseRequest<MicrosoftAuthenticatorAuthenticationMethodConfiguration> {
	
    /**
     * The request for the MicrosoftAuthenticatorAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftAuthenticatorAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodConfiguration with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethodConfiguration> patchAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodConfiguration with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethodConfiguration patch(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethodConfiguration> postAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethodConfiguration post(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MicrosoftAuthenticatorAuthenticationMethodConfiguration> putAsync(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MicrosoftAuthenticatorAuthenticationMethodConfiguration put(@Nonnull final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newMicrosoftAuthenticatorAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

