// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ItemRetentionLabel;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Retention Label Request.
 */
public class ItemRetentionLabelRequest extends BaseRequest<ItemRetentionLabel> {
	
    /**
     * The request for the ItemRetentionLabel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemRetentionLabelRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemRetentionLabel.class);
    }

    /**
     * Gets the ItemRetentionLabel from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemRetentionLabel> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ItemRetentionLabel from the service
     *
     * @return the ItemRetentionLabel from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemRetentionLabel get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemRetentionLabel> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ItemRetentionLabel delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ItemRetentionLabel with a source
     *
     * @param sourceItemRetentionLabel the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemRetentionLabel> patchAsync(@Nonnull final ItemRetentionLabel sourceItemRetentionLabel) {
        return sendAsync(HttpMethod.PATCH, sourceItemRetentionLabel);
    }

    /**
     * Patches this ItemRetentionLabel with a source
     *
     * @param sourceItemRetentionLabel the source object with updates
     * @return the updated ItemRetentionLabel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemRetentionLabel patch(@Nonnull final ItemRetentionLabel sourceItemRetentionLabel) throws ClientException {
        return send(HttpMethod.PATCH, sourceItemRetentionLabel);
    }

    /**
     * Creates a ItemRetentionLabel with a new object
     *
     * @param newItemRetentionLabel the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemRetentionLabel> postAsync(@Nonnull final ItemRetentionLabel newItemRetentionLabel) {
        return sendAsync(HttpMethod.POST, newItemRetentionLabel);
    }

    /**
     * Creates a ItemRetentionLabel with a new object
     *
     * @param newItemRetentionLabel the new object to create
     * @return the created ItemRetentionLabel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemRetentionLabel post(@Nonnull final ItemRetentionLabel newItemRetentionLabel) throws ClientException {
        return send(HttpMethod.POST, newItemRetentionLabel);
    }

    /**
     * Creates a ItemRetentionLabel with a new object
     *
     * @param newItemRetentionLabel the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemRetentionLabel> putAsync(@Nonnull final ItemRetentionLabel newItemRetentionLabel) {
        return sendAsync(HttpMethod.PUT, newItemRetentionLabel);
    }

    /**
     * Creates a ItemRetentionLabel with a new object
     *
     * @param newItemRetentionLabel the object to create/update
     * @return the created ItemRetentionLabel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemRetentionLabel put(@Nonnull final ItemRetentionLabel newItemRetentionLabel) throws ClientException {
        return send(HttpMethod.PUT, newItemRetentionLabel);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ItemRetentionLabelRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ItemRetentionLabelRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

