// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DelegatedAdminRelationship;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Relationship Request.
 */
public class DelegatedAdminRelationshipRequest extends BaseRequest<DelegatedAdminRelationship> {
	
    /**
     * The request for the DelegatedAdminRelationship
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DelegatedAdminRelationshipRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends DelegatedAdminRelationship> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DelegatedAdminRelationship
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DelegatedAdminRelationshipRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DelegatedAdminRelationship.class);
    }

    /**
     * Gets the DelegatedAdminRelationship from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminRelationship> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DelegatedAdminRelationship from the service
     *
     * @return the DelegatedAdminRelationship from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminRelationship get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminRelationship> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DelegatedAdminRelationship delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DelegatedAdminRelationship with a source
     *
     * @param sourceDelegatedAdminRelationship the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminRelationship> patchAsync(@Nonnull final DelegatedAdminRelationship sourceDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.PATCH, sourceDelegatedAdminRelationship);
    }

    /**
     * Patches this DelegatedAdminRelationship with a source
     *
     * @param sourceDelegatedAdminRelationship the source object with updates
     * @return the updated DelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminRelationship patch(@Nonnull final DelegatedAdminRelationship sourceDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.PATCH, sourceDelegatedAdminRelationship);
    }

    /**
     * Creates a DelegatedAdminRelationship with a new object
     *
     * @param newDelegatedAdminRelationship the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminRelationship> postAsync(@Nonnull final DelegatedAdminRelationship newDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.POST, newDelegatedAdminRelationship);
    }

    /**
     * Creates a DelegatedAdminRelationship with a new object
     *
     * @param newDelegatedAdminRelationship the new object to create
     * @return the created DelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminRelationship post(@Nonnull final DelegatedAdminRelationship newDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.POST, newDelegatedAdminRelationship);
    }

    /**
     * Creates a DelegatedAdminRelationship with a new object
     *
     * @param newDelegatedAdminRelationship the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminRelationship> putAsync(@Nonnull final DelegatedAdminRelationship newDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.PUT, newDelegatedAdminRelationship);
    }

    /**
     * Creates a DelegatedAdminRelationship with a new object
     *
     * @param newDelegatedAdminRelationship the object to create/update
     * @return the created DelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminRelationship put(@Nonnull final DelegatedAdminRelationship newDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.PUT, newDelegatedAdminRelationship);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminRelationshipRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminRelationshipRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

