// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CustomExtensionStageSetting;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Extension Stage Setting Request.
 */
public class CustomExtensionStageSettingRequest extends BaseRequest<CustomExtensionStageSetting> {
	
    /**
     * The request for the CustomExtensionStageSetting
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustomExtensionStageSettingRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustomExtensionStageSetting.class);
    }

    /**
     * Gets the CustomExtensionStageSetting from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomExtensionStageSetting> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CustomExtensionStageSetting from the service
     *
     * @return the CustomExtensionStageSetting from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomExtensionStageSetting get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomExtensionStageSetting> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CustomExtensionStageSetting delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CustomExtensionStageSetting with a source
     *
     * @param sourceCustomExtensionStageSetting the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomExtensionStageSetting> patchAsync(@Nonnull final CustomExtensionStageSetting sourceCustomExtensionStageSetting) {
        return sendAsync(HttpMethod.PATCH, sourceCustomExtensionStageSetting);
    }

    /**
     * Patches this CustomExtensionStageSetting with a source
     *
     * @param sourceCustomExtensionStageSetting the source object with updates
     * @return the updated CustomExtensionStageSetting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomExtensionStageSetting patch(@Nonnull final CustomExtensionStageSetting sourceCustomExtensionStageSetting) throws ClientException {
        return send(HttpMethod.PATCH, sourceCustomExtensionStageSetting);
    }

    /**
     * Creates a CustomExtensionStageSetting with a new object
     *
     * @param newCustomExtensionStageSetting the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomExtensionStageSetting> postAsync(@Nonnull final CustomExtensionStageSetting newCustomExtensionStageSetting) {
        return sendAsync(HttpMethod.POST, newCustomExtensionStageSetting);
    }

    /**
     * Creates a CustomExtensionStageSetting with a new object
     *
     * @param newCustomExtensionStageSetting the new object to create
     * @return the created CustomExtensionStageSetting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomExtensionStageSetting post(@Nonnull final CustomExtensionStageSetting newCustomExtensionStageSetting) throws ClientException {
        return send(HttpMethod.POST, newCustomExtensionStageSetting);
    }

    /**
     * Creates a CustomExtensionStageSetting with a new object
     *
     * @param newCustomExtensionStageSetting the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomExtensionStageSetting> putAsync(@Nonnull final CustomExtensionStageSetting newCustomExtensionStageSetting) {
        return sendAsync(HttpMethod.PUT, newCustomExtensionStageSetting);
    }

    /**
     * Creates a CustomExtensionStageSetting with a new object
     *
     * @param newCustomExtensionStageSetting the object to create/update
     * @return the created CustomExtensionStageSetting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomExtensionStageSetting put(@Nonnull final CustomExtensionStageSetting newCustomExtensionStageSetting) throws ClientException {
        return send(HttpMethod.PUT, newCustomExtensionStageSetting);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CustomExtensionStageSettingRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CustomExtensionStageSettingRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

