// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BrowserSite;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Site Request.
 */
public class BrowserSiteRequest extends BaseRequest<BrowserSite> {
	
    /**
     * The request for the BrowserSite
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BrowserSiteRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BrowserSite.class);
    }

    /**
     * Gets the BrowserSite from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BrowserSite> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BrowserSite from the service
     *
     * @return the BrowserSite from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BrowserSite get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BrowserSite> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BrowserSite delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BrowserSite with a source
     *
     * @param sourceBrowserSite the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BrowserSite> patchAsync(@Nonnull final BrowserSite sourceBrowserSite) {
        return sendAsync(HttpMethod.PATCH, sourceBrowserSite);
    }

    /**
     * Patches this BrowserSite with a source
     *
     * @param sourceBrowserSite the source object with updates
     * @return the updated BrowserSite
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BrowserSite patch(@Nonnull final BrowserSite sourceBrowserSite) throws ClientException {
        return send(HttpMethod.PATCH, sourceBrowserSite);
    }

    /**
     * Creates a BrowserSite with a new object
     *
     * @param newBrowserSite the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BrowserSite> postAsync(@Nonnull final BrowserSite newBrowserSite) {
        return sendAsync(HttpMethod.POST, newBrowserSite);
    }

    /**
     * Creates a BrowserSite with a new object
     *
     * @param newBrowserSite the new object to create
     * @return the created BrowserSite
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BrowserSite post(@Nonnull final BrowserSite newBrowserSite) throws ClientException {
        return send(HttpMethod.POST, newBrowserSite);
    }

    /**
     * Creates a BrowserSite with a new object
     *
     * @param newBrowserSite the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BrowserSite> putAsync(@Nonnull final BrowserSite newBrowserSite) {
        return sendAsync(HttpMethod.PUT, newBrowserSite);
    }

    /**
     * Creates a BrowserSite with a new object
     *
     * @param newBrowserSite the object to create/update
     * @return the created BrowserSite
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BrowserSite put(@Nonnull final BrowserSite newBrowserSite) throws ClientException {
        return send(HttpMethod.PUT, newBrowserSite);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BrowserSiteRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BrowserSiteRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

