// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingBusiness;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.StaffAvailabilityItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.BookingBusinessGetStaffAvailabilityParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Business Request Builder.
 */
public class BookingBusinessRequestBuilder extends BaseRequestBuilder<BookingBusiness> {

    /**
     * The request builder for the BookingBusiness
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingBusinessRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the BookingBusinessRequest instance
     */
    @Nonnull
    public BookingBusinessRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the BookingBusinessRequest instance
     */
    @Nonnull
    public BookingBusinessRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.BookingBusinessRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the BookingAppointment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingAppointmentCollectionRequestBuilder appointments() {
        return new com.microsoft.graph.requests.BookingAppointmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("appointments"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingAppointment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingAppointmentRequestBuilder appointments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingAppointmentRequestBuilder(getRequestUrlWithAdditionalSegment("appointments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingAppointment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingAppointmentCollectionRequestBuilder calendarView() {
        return new com.microsoft.graph.requests.BookingAppointmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("calendarView"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingAppointment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingAppointmentRequestBuilder calendarView(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingAppointmentRequestBuilder(getRequestUrlWithAdditionalSegment("calendarView") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingCustomerBase collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCustomerBaseCollectionRequestBuilder customers() {
        return new com.microsoft.graph.requests.BookingCustomerBaseCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("customers"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingCustomerBase item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCustomerBaseRequestBuilder customers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingCustomerBaseRequestBuilder(getRequestUrlWithAdditionalSegment("customers") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingCustomQuestion collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCustomQuestionCollectionRequestBuilder customQuestions() {
        return new com.microsoft.graph.requests.BookingCustomQuestionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("customQuestions"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingCustomQuestion item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCustomQuestionRequestBuilder customQuestions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingCustomQuestionRequestBuilder(getRequestUrlWithAdditionalSegment("customQuestions") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingService collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingServiceCollectionRequestBuilder services() {
        return new com.microsoft.graph.requests.BookingServiceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("services"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingService item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingServiceRequestBuilder services(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingServiceRequestBuilder(getRequestUrlWithAdditionalSegment("services") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingStaffMemberBase collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingStaffMemberBaseCollectionRequestBuilder staffMembers() {
        return new com.microsoft.graph.requests.BookingStaffMemberBaseCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("staffMembers"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingStaffMemberBase item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingStaffMemberBaseRequestBuilder staffMembers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingStaffMemberBaseRequestBuilder(getRequestUrlWithAdditionalSegment("staffMembers") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public BookingBusinessGetStaffAvailabilityCollectionRequestBuilder getStaffAvailability(@Nonnull final BookingBusinessGetStaffAvailabilityParameterSet parameters) {
        return new BookingBusinessGetStaffAvailabilityCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getStaffAvailability"), getClient(), null, parameters);
    }

    /**
     * Makes the scheduling page of this business available to the general public.
     * @return the request builder
     */
    @Nonnull
    public BookingBusinessPublishRequestBuilder publish() {
        return new BookingBusinessPublishRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.publish"), getClient(), null);
    }

    /**
     * Prevents the general public from seeing the scheduling page of this business.
     * @return the request builder
     */
    @Nonnull
    public BookingBusinessUnpublishRequestBuilder unpublish() {
        return new BookingBusinessUnpublishRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unpublish"), getClient(), null);
    }
}
