// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingAppointment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.BookingAppointmentCancelParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Appointment Request Builder.
 */
public class BookingAppointmentRequestBuilder extends BaseRequestBuilder<BookingAppointment> {

    /**
     * The request builder for the BookingAppointment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingAppointmentRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the BookingAppointmentRequest instance
     */
    @Nonnull
    public BookingAppointmentRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the BookingAppointmentRequest instance
     */
    @Nonnull
    public BookingAppointmentRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.BookingAppointmentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Cancels the giving booking appointment, sending a message to the involved parties.
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public BookingAppointmentCancelRequestBuilder cancel(@Nonnull final BookingAppointmentCancelParameterSet parameters) {
        return new BookingAppointmentCancelRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), getClient(), null, parameters);
    }
}
