// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AttributeMappingFunctionSchema;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attribute Mapping Function Schema Request.
 */
public class AttributeMappingFunctionSchemaRequest extends BaseRequest<AttributeMappingFunctionSchema> {
	
    /**
     * The request for the AttributeMappingFunctionSchema
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AttributeMappingFunctionSchemaRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttributeMappingFunctionSchema.class);
    }

    /**
     * Gets the AttributeMappingFunctionSchema from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeMappingFunctionSchema> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AttributeMappingFunctionSchema from the service
     *
     * @return the AttributeMappingFunctionSchema from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeMappingFunctionSchema get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeMappingFunctionSchema> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AttributeMappingFunctionSchema delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AttributeMappingFunctionSchema with a source
     *
     * @param sourceAttributeMappingFunctionSchema the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeMappingFunctionSchema> patchAsync(@Nonnull final AttributeMappingFunctionSchema sourceAttributeMappingFunctionSchema) {
        return sendAsync(HttpMethod.PATCH, sourceAttributeMappingFunctionSchema);
    }

    /**
     * Patches this AttributeMappingFunctionSchema with a source
     *
     * @param sourceAttributeMappingFunctionSchema the source object with updates
     * @return the updated AttributeMappingFunctionSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeMappingFunctionSchema patch(@Nonnull final AttributeMappingFunctionSchema sourceAttributeMappingFunctionSchema) throws ClientException {
        return send(HttpMethod.PATCH, sourceAttributeMappingFunctionSchema);
    }

    /**
     * Creates a AttributeMappingFunctionSchema with a new object
     *
     * @param newAttributeMappingFunctionSchema the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeMappingFunctionSchema> postAsync(@Nonnull final AttributeMappingFunctionSchema newAttributeMappingFunctionSchema) {
        return sendAsync(HttpMethod.POST, newAttributeMappingFunctionSchema);
    }

    /**
     * Creates a AttributeMappingFunctionSchema with a new object
     *
     * @param newAttributeMappingFunctionSchema the new object to create
     * @return the created AttributeMappingFunctionSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeMappingFunctionSchema post(@Nonnull final AttributeMappingFunctionSchema newAttributeMappingFunctionSchema) throws ClientException {
        return send(HttpMethod.POST, newAttributeMappingFunctionSchema);
    }

    /**
     * Creates a AttributeMappingFunctionSchema with a new object
     *
     * @param newAttributeMappingFunctionSchema the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeMappingFunctionSchema> putAsync(@Nonnull final AttributeMappingFunctionSchema newAttributeMappingFunctionSchema) {
        return sendAsync(HttpMethod.PUT, newAttributeMappingFunctionSchema);
    }

    /**
     * Creates a AttributeMappingFunctionSchema with a new object
     *
     * @param newAttributeMappingFunctionSchema the object to create/update
     * @return the created AttributeMappingFunctionSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeMappingFunctionSchema put(@Nonnull final AttributeMappingFunctionSchema newAttributeMappingFunctionSchema) throws ClientException {
        return send(HttpMethod.PUT, newAttributeMappingFunctionSchema);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AttributeMappingFunctionSchemaRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AttributeMappingFunctionSchemaRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

