// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Management Policy Request.
 */
public class AppManagementPolicyRequest extends BaseRequest<AppManagementPolicy> {
	
    /**
     * The request for the AppManagementPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppManagementPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppManagementPolicy.class);
    }

    /**
     * Gets the AppManagementPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AppManagementPolicy from the service
     *
     * @return the AppManagementPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppManagementPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AppManagementPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AppManagementPolicy with a source
     *
     * @param sourceAppManagementPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> patchAsync(@Nonnull final AppManagementPolicy sourceAppManagementPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAppManagementPolicy);
    }

    /**
     * Patches this AppManagementPolicy with a source
     *
     * @param sourceAppManagementPolicy the source object with updates
     * @return the updated AppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppManagementPolicy patch(@Nonnull final AppManagementPolicy sourceAppManagementPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAppManagementPolicy);
    }

    /**
     * Creates a AppManagementPolicy with a new object
     *
     * @param newAppManagementPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> postAsync(@Nonnull final AppManagementPolicy newAppManagementPolicy) {
        return sendAsync(HttpMethod.POST, newAppManagementPolicy);
    }

    /**
     * Creates a AppManagementPolicy with a new object
     *
     * @param newAppManagementPolicy the new object to create
     * @return the created AppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppManagementPolicy post(@Nonnull final AppManagementPolicy newAppManagementPolicy) throws ClientException {
        return send(HttpMethod.POST, newAppManagementPolicy);
    }

    /**
     * Creates a AppManagementPolicy with a new object
     *
     * @param newAppManagementPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> putAsync(@Nonnull final AppManagementPolicy newAppManagementPolicy) {
        return sendAsync(HttpMethod.PUT, newAppManagementPolicy);
    }

    /**
     * Creates a AppManagementPolicy with a new object
     *
     * @param newAppManagementPolicy the object to create/update
     * @return the created AppManagementPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppManagementPolicy put(@Nonnull final AppManagementPolicy newAppManagementPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAppManagementPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AppManagementPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AppManagementPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

