// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AgreementFile;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement File Request.
 */
public class AgreementFileRequest extends BaseRequest<AgreementFile> {
	
    /**
     * The request for the AgreementFile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementFileRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFile.class);
    }

    /**
     * Gets the AgreementFile from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFile> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AgreementFile from the service
     *
     * @return the AgreementFile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFile get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFile> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AgreementFile delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFile> patchAsync(@Nonnull final AgreementFile sourceAgreementFile) {
        return sendAsync(HttpMethod.PATCH, sourceAgreementFile);
    }

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @return the updated AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFile patch(@Nonnull final AgreementFile sourceAgreementFile) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFile> postAsync(@Nonnull final AgreementFile newAgreementFile) {
        return sendAsync(HttpMethod.POST, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFile post(@Nonnull final AgreementFile newAgreementFile) throws ClientException {
        return send(HttpMethod.POST, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFile> putAsync(@Nonnull final AgreementFile newAgreementFile) {
        return sendAsync(HttpMethod.PUT, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFile put(@Nonnull final AgreementFile newAgreementFile) throws ClientException {
        return send(HttpMethod.PUT, newAgreementFile);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

