// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageResourceRoleScope;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Resource Role Scope Request.
 */
public class AccessPackageResourceRoleScopeRequest extends BaseRequest<AccessPackageResourceRoleScope> {
	
    /**
     * The request for the AccessPackageResourceRoleScope
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageResourceRoleScopeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageResourceRoleScope.class);
    }

    /**
     * Gets the AccessPackageResourceRoleScope from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRoleScope> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageResourceRoleScope from the service
     *
     * @return the AccessPackageResourceRoleScope from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRoleScope get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRoleScope> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageResourceRoleScope delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageResourceRoleScope with a source
     *
     * @param sourceAccessPackageResourceRoleScope the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRoleScope> patchAsync(@Nonnull final AccessPackageResourceRoleScope sourceAccessPackageResourceRoleScope) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageResourceRoleScope);
    }

    /**
     * Patches this AccessPackageResourceRoleScope with a source
     *
     * @param sourceAccessPackageResourceRoleScope the source object with updates
     * @return the updated AccessPackageResourceRoleScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRoleScope patch(@Nonnull final AccessPackageResourceRoleScope sourceAccessPackageResourceRoleScope) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageResourceRoleScope);
    }

    /**
     * Creates a AccessPackageResourceRoleScope with a new object
     *
     * @param newAccessPackageResourceRoleScope the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRoleScope> postAsync(@Nonnull final AccessPackageResourceRoleScope newAccessPackageResourceRoleScope) {
        return sendAsync(HttpMethod.POST, newAccessPackageResourceRoleScope);
    }

    /**
     * Creates a AccessPackageResourceRoleScope with a new object
     *
     * @param newAccessPackageResourceRoleScope the new object to create
     * @return the created AccessPackageResourceRoleScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRoleScope post(@Nonnull final AccessPackageResourceRoleScope newAccessPackageResourceRoleScope) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageResourceRoleScope);
    }

    /**
     * Creates a AccessPackageResourceRoleScope with a new object
     *
     * @param newAccessPackageResourceRoleScope the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceRoleScope> putAsync(@Nonnull final AccessPackageResourceRoleScope newAccessPackageResourceRoleScope) {
        return sendAsync(HttpMethod.PUT, newAccessPackageResourceRoleScope);
    }

    /**
     * Creates a AccessPackageResourceRoleScope with a new object
     *
     * @param newAccessPackageResourceRoleScope the object to create/update
     * @return the created AccessPackageResourceRoleScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceRoleScope put(@Nonnull final AccessPackageResourceRoleScope newAccessPackageResourceRoleScope) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageResourceRoleScope);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRoleScopeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceRoleScopeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

