// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentWorkflowExtension;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Workflow Extension Request.
 */
public class AccessPackageAssignmentWorkflowExtensionRequest extends BaseRequest<AccessPackageAssignmentWorkflowExtension> {
	
    /**
     * The request for the AccessPackageAssignmentWorkflowExtension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentWorkflowExtensionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentWorkflowExtension.class);
    }

    /**
     * Gets the AccessPackageAssignmentWorkflowExtension from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentWorkflowExtension> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageAssignmentWorkflowExtension from the service
     *
     * @return the AccessPackageAssignmentWorkflowExtension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentWorkflowExtension get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentWorkflowExtension> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageAssignmentWorkflowExtension delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageAssignmentWorkflowExtension with a source
     *
     * @param sourceAccessPackageAssignmentWorkflowExtension the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentWorkflowExtension> patchAsync(@Nonnull final AccessPackageAssignmentWorkflowExtension sourceAccessPackageAssignmentWorkflowExtension) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Patches this AccessPackageAssignmentWorkflowExtension with a source
     *
     * @param sourceAccessPackageAssignmentWorkflowExtension the source object with updates
     * @return the updated AccessPackageAssignmentWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentWorkflowExtension patch(@Nonnull final AccessPackageAssignmentWorkflowExtension sourceAccessPackageAssignmentWorkflowExtension) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentWorkflowExtension the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentWorkflowExtension> postAsync(@Nonnull final AccessPackageAssignmentWorkflowExtension newAccessPackageAssignmentWorkflowExtension) {
        return sendAsync(HttpMethod.POST, newAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentWorkflowExtension the new object to create
     * @return the created AccessPackageAssignmentWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentWorkflowExtension post(@Nonnull final AccessPackageAssignmentWorkflowExtension newAccessPackageAssignmentWorkflowExtension) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentWorkflowExtension the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentWorkflowExtension> putAsync(@Nonnull final AccessPackageAssignmentWorkflowExtension newAccessPackageAssignmentWorkflowExtension) {
        return sendAsync(HttpMethod.PUT, newAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentWorkflowExtension the object to create/update
     * @return the created AccessPackageAssignmentWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentWorkflowExtension put(@Nonnull final AccessPackageAssignmentWorkflowExtension newAccessPackageAssignmentWorkflowExtension) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageAssignmentWorkflowExtension);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentWorkflowExtensionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentWorkflowExtensionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

