// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Watermark Protection Values.
 */
public class WatermarkProtectionValues implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Is Enabled For Content Sharing.
     * Indicates whether to apply a watermark to any shared content.
     */
    @SerializedName(value = "isEnabledForContentSharing", alternate = {"IsEnabledForContentSharing"})
    @Expose
	@Nullable
    public Boolean isEnabledForContentSharing;

    /**
     * The Is Enabled For Video.
     * Indicates whether to apply a watermark to everyone's video feed.
     */
    @SerializedName(value = "isEnabledForVideo", alternate = {"IsEnabledForVideo"})
    @Expose
	@Nullable
    public Boolean isEnabledForVideo;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
