// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.VirtualEventRegistrationQuestionAnswer;
import com.microsoft.graph.models.VirtualEventAttendeeRegistrationStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Registration.
 */
public class VirtualEventRegistration extends Entity implements IJsonBackedObject {


    /**
     * The Cancelation Date Time.
     * 
     */
    @SerializedName(value = "cancelationDateTime", alternate = {"CancelationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime cancelationDateTime;

    /**
     * The Email.
     * 
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The First Name.
     * 
     */
    @SerializedName(value = "firstName", alternate = {"FirstName"})
    @Expose
	@Nullable
    public String firstName;

    /**
     * The Last Name.
     * 
     */
    @SerializedName(value = "lastName", alternate = {"LastName"})
    @Expose
	@Nullable
    public String lastName;

    /**
     * The Registration Date Time.
     * 
     */
    @SerializedName(value = "registrationDateTime", alternate = {"RegistrationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime registrationDateTime;

    /**
     * The Registration Question Answers.
     * 
     */
    @SerializedName(value = "registrationQuestionAnswers", alternate = {"RegistrationQuestionAnswers"})
    @Expose
	@Nullable
    public java.util.List<VirtualEventRegistrationQuestionAnswer> registrationQuestionAnswers;

    /**
     * The Status.
     * 
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public VirtualEventAttendeeRegistrationStatus status;

    /**
     * The User Id.
     * 
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
