// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Simulation Event Info.
 */
public class UserSimulationEventInfo implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Browser.
     * Browser information from where the simulation event was initiated by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "browser", alternate = {"Browser"})
    @Expose
	@Nullable
    public String browser;

    /**
     * The Event Date Time.
     * Date and time of the simulation event by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "eventDateTime", alternate = {"EventDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime eventDateTime;

    /**
     * The Event Name.
     * Name of the simulation event by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "eventName", alternate = {"EventName"})
    @Expose
	@Nullable
    public String eventName;

    /**
     * The Ip Address.
     * IP address from where the simulation event was initiated by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "ipAddress", alternate = {"IpAddress"})
    @Expose
	@Nullable
    public String ipAddress;

    /**
     * The Os Platform Device Details.
     * The operating system, platform, and device details from where the simulation event was initiated by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "osPlatformDeviceDetails", alternate = {"OsPlatformDeviceDetails"})
    @Expose
	@Nullable
    public String osPlatformDeviceDetails;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
