// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.TeleconferenceDeviceMediaQuality;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teleconference Device Video Quality.
 */
public class TeleconferenceDeviceVideoQuality extends TeleconferenceDeviceMediaQuality implements IJsonBackedObject {


    /**
     * The Average Inbound Bit Rate.
     * The average inbound stream video bit rate per second.
     */
    @SerializedName(value = "averageInboundBitRate", alternate = {"AverageInboundBitRate"})
    @Expose
	@Nullable
    public Double averageInboundBitRate;

    /**
     * The Average Inbound Frame Rate.
     * The average inbound stream video frame rate per second.
     */
    @SerializedName(value = "averageInboundFrameRate", alternate = {"AverageInboundFrameRate"})
    @Expose
	@Nullable
    public Double averageInboundFrameRate;

    /**
     * The Average Outbound Bit Rate.
     * The average outbound stream video bit rate per second.
     */
    @SerializedName(value = "averageOutboundBitRate", alternate = {"AverageOutboundBitRate"})
    @Expose
	@Nullable
    public Double averageOutboundBitRate;

    /**
     * The Average Outbound Frame Rate.
     * The average outbound stream video frame rate per second.
     */
    @SerializedName(value = "averageOutboundFrameRate", alternate = {"AverageOutboundFrameRate"})
    @Expose
	@Nullable
    public Double averageOutboundFrameRate;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
