// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.EligibilityScheduleInstanceFilterByCurrentUserOptions;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleInstance;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Instance Filter By Current User Parameter Set.
 */
public class PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet {
    /**
     * The on.
     * 
     */
    @SerializedName(value = "on", alternate = {"On"})
    @Expose
	@Nullable
    public EligibilityScheduleInstanceFilterByCurrentUserOptions on;


    /**
     * Instiaciates a new PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet
     */
    public PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet() {}
    /**
     * Instiaciates a new PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet(@Nonnull final PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder builder) {
        this.on = builder.on;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder newBuilder() {
        return new PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder();
    }
    /**
     * Fluent builder for the PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet
     */
    public static final class PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder {
        /**
         * The on parameter value
         */
        @Nullable
        protected EligibilityScheduleInstanceFilterByCurrentUserOptions on;
        /**
         * Sets the On
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder withOn(@Nullable final EligibilityScheduleInstanceFilterByCurrentUserOptions val) {
            this.on = val;
            return this;
        }
        /**
         * Instanciates a new PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder
         */
        @Nullable
        protected PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet build() {
            return new PrivilegedAccessGroupEligibilityScheduleInstanceFilterByCurrentUserParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.on != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("on", on));
        }
        return result;
    }
}
