// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ApprovalCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleInstanceCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleRequestCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleInstanceCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestCollectionPage;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group.
 */
public class PrivilegedAccessGroup extends Entity implements IJsonBackedObject {


    /**
     * The Assignment Approvals.
     * 
     */
    @SerializedName(value = "assignmentApprovals", alternate = {"AssignmentApprovals"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ApprovalCollectionPage assignmentApprovals;

    /**
     * The Assignment Schedule Instances.
     * The instances of assignment schedules to activate a just-in-time access.
     */
    @SerializedName(value = "assignmentScheduleInstances", alternate = {"AssignmentScheduleInstances"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleInstanceCollectionPage assignmentScheduleInstances;

    /**
     * The Assignment Schedule Requests.
     * The schedule requests for operations to create, update, delete, extend, and renew an assignment.
     */
    @SerializedName(value = "assignmentScheduleRequests", alternate = {"AssignmentScheduleRequests"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleRequestCollectionPage assignmentScheduleRequests;

    /**
     * The Assignment Schedules.
     * The assignment schedules to activate a just-in-time access.
     */
    @SerializedName(value = "assignmentSchedules", alternate = {"AssignmentSchedules"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleCollectionPage assignmentSchedules;

    /**
     * The Eligibility Schedule Instances.
     * The instances of eligibility schedules to activate a just-in-time access.
     */
    @SerializedName(value = "eligibilityScheduleInstances", alternate = {"EligibilityScheduleInstances"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleInstanceCollectionPage eligibilityScheduleInstances;

    /**
     * The Eligibility Schedule Requests.
     * The schedule requests for operations to create, update, delete, extend, and renew an eligibility.
     */
    @SerializedName(value = "eligibilityScheduleRequests", alternate = {"EligibilityScheduleRequests"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestCollectionPage eligibilityScheduleRequests;

    /**
     * The Eligibility Schedules.
     * The eligibility schedules to activate a just-in-time access.
     */
    @SerializedName(value = "eligibilitySchedules", alternate = {"EligibilitySchedules"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleCollectionPage eligibilitySchedules;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("assignmentApprovals")) {
            assignmentApprovals = serializer.deserializeObject(json.get("assignmentApprovals"), com.microsoft.graph.requests.ApprovalCollectionPage.class);
        }

        if (json.has("assignmentScheduleInstances")) {
            assignmentScheduleInstances = serializer.deserializeObject(json.get("assignmentScheduleInstances"), com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleInstanceCollectionPage.class);
        }

        if (json.has("assignmentScheduleRequests")) {
            assignmentScheduleRequests = serializer.deserializeObject(json.get("assignmentScheduleRequests"), com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleRequestCollectionPage.class);
        }

        if (json.has("assignmentSchedules")) {
            assignmentSchedules = serializer.deserializeObject(json.get("assignmentSchedules"), com.microsoft.graph.requests.PrivilegedAccessGroupAssignmentScheduleCollectionPage.class);
        }

        if (json.has("eligibilityScheduleInstances")) {
            eligibilityScheduleInstances = serializer.deserializeObject(json.get("eligibilityScheduleInstances"), com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleInstanceCollectionPage.class);
        }

        if (json.has("eligibilityScheduleRequests")) {
            eligibilityScheduleRequests = serializer.deserializeObject(json.get("eligibilityScheduleRequests"), com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestCollectionPage.class);
        }

        if (json.has("eligibilitySchedules")) {
            eligibilitySchedules = serializer.deserializeObject(json.get("eligibilitySchedules"), com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleCollectionPage.class);
        }
    }
}
