// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AuthenticationPhoneType;
import com.microsoft.graph.models.AuthenticationMethodSignInState;
import com.microsoft.graph.models.AuthenticationMethod;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Phone Authentication Method.
 */
public class PhoneAuthenticationMethod extends AuthenticationMethod implements IJsonBackedObject {


    /**
     * The Phone Number.
     * The phone number to text or call for authentication. Phone numbers use the format +{country code} {number}x{extension}, with extension optional. For example, +1 5555551234 or +1 5555551234x123 are valid. Numbers are rejected when creating or updating if they don't match the required format.
     */
    @SerializedName(value = "phoneNumber", alternate = {"PhoneNumber"})
    @Expose
	@Nullable
    public String phoneNumber;

    /**
     * The Phone Type.
     * The type of this phone. Possible values are: mobile, alternateMobile, or office.
     */
    @SerializedName(value = "phoneType", alternate = {"PhoneType"})
    @Expose
	@Nullable
    public AuthenticationPhoneType phoneType;

    /**
     * The Sms Sign In State.
     * Whether a phone is ready to be used for SMS sign-in or not. Possible values are: notSupported, notAllowedByPolicy, notEnabled, phoneNumberNotUnique, ready, or notConfigured, unknownFutureValue.
     */
    @SerializedName(value = "smsSignInState", alternate = {"SmsSignInState"})
    @Expose
	@Nullable
    public AuthenticationMethodSignInState smsSignInState;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
