// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PayloadBrand;
import com.microsoft.graph.models.PayloadComplexity;
import com.microsoft.graph.models.EmailIdentity;
import com.microsoft.graph.models.PayloadDetail;
import com.microsoft.graph.models.PayloadIndustry;
import com.microsoft.graph.models.PayloadDeliveryPlatform;
import com.microsoft.graph.models.SimulationAttackType;
import com.microsoft.graph.models.SimulationContentSource;
import com.microsoft.graph.models.SimulationContentStatus;
import com.microsoft.graph.models.SimulationAttackTechnique;
import com.microsoft.graph.models.PayloadTheme;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Payload.
 */
public class Payload extends Entity implements IJsonBackedObject {


    /**
     * The Brand.
     * The branch of a payload. Possible values are: unknown, other, americanExpress, capitalOne, dhl, docuSign, dropbox, facebook, firstAmerican, microsoft, netflix, scotiabank, sendGrid, stewartTitle, tesco, wellsFargo, syrinxCloud, adobe, teams, zoom, unknownFutureValue.
     */
    @SerializedName(value = "brand", alternate = {"Brand"})
    @Expose
	@Nullable
    public PayloadBrand brand;

    /**
     * The Complexity.
     * The complexity of a payload. Possible values are: unknown, low, medium, high, unknownFutureValue.
     */
    @SerializedName(value = "complexity", alternate = {"Complexity"})
    @Expose
	@Nullable
    public PayloadComplexity complexity;

    /**
     * The Created By.
     * Identity of the user who created the attack simulation and training campaign payload.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public EmailIdentity createdBy;

    /**
     * The Created Date Time.
     * Date and time when the attack simulation and training campaign payload. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * Description of the attack simulation and training campaign payload.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Detail.
     * Additional details about the payload.
     */
    @SerializedName(value = "detail", alternate = {"Detail"})
    @Expose
	@Nullable
    public PayloadDetail detail;

    /**
     * The Display Name.
     * Display name of the attack simulation and training campaign payload. Supports $filter and $orderby.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Industry.
     * Industry of a payload. Possible values are: unknown, other, banking, businessServices, consumerServices, education, energy, construction, consulting, financialServices, government, hospitality, insurance, legal, courierServices, IT, healthcare, manufacturing, retail, telecom, realEstate, unknownFutureValue.
     */
    @SerializedName(value = "industry", alternate = {"Industry"})
    @Expose
	@Nullable
    public PayloadIndustry industry;

    /**
     * The Is Automated.
     * Indicates whether the attack simulation and training campaign payload was created from an automation flow. Supports $filter and $orderby.
     */
    @SerializedName(value = "isAutomated", alternate = {"IsAutomated"})
    @Expose
	@Nullable
    public Boolean isAutomated;

    /**
     * The Is Controversial.
     * Indicates whether the payload is controversial.
     */
    @SerializedName(value = "isControversial", alternate = {"IsControversial"})
    @Expose
	@Nullable
    public Boolean isControversial;

    /**
     * The Is Current Event.
     * Indicates whether the payload is from any recent event.
     */
    @SerializedName(value = "isCurrentEvent", alternate = {"IsCurrentEvent"})
    @Expose
	@Nullable
    public Boolean isCurrentEvent;

    /**
     * The Language.
     * Payload language.
     */
    @SerializedName(value = "language", alternate = {"Language"})
    @Expose
	@Nullable
    public String language;

    /**
     * The Last Modified By.
     * Identity of the user who most recently modified the attack simulation and training campaign payload.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public EmailIdentity lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * Date and time when the attack simulation and training campaign payload was last modified. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Payload Tags.
     * Free text tags for a payload.
     */
    @SerializedName(value = "payloadTags", alternate = {"PayloadTags"})
    @Expose
	@Nullable
    public java.util.List<String> payloadTags;

    /**
     * The Platform.
     * The payload delivery platform for a simulation. Possible values are: unknown, sms, email, teams, unknownFutureValue.
     */
    @SerializedName(value = "platform", alternate = {"Platform"})
    @Expose
	@Nullable
    public PayloadDeliveryPlatform platform;

    /**
     * The Predicted Compromise Rate.
     * Predicted probability for a payload to phish a targeted user.
     */
    @SerializedName(value = "predictedCompromiseRate", alternate = {"PredictedCompromiseRate"})
    @Expose
	@Nullable
    public Double predictedCompromiseRate;

    /**
     * The Simulation Attack Type.
     * Attack type of the attack simulation and training campaign. Supports $filter and $orderby. Possible values are: unknown, social, cloud, endpoint, unknownFutureValue.
     */
    @SerializedName(value = "simulationAttackType", alternate = {"SimulationAttackType"})
    @Expose
	@Nullable
    public SimulationAttackType simulationAttackType;

    /**
     * The Source.
     * Simulation content source. Supports $filter and $orderby. Possible values are: unknown, global, tenant, unknownFutureValue.
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public SimulationContentSource source;

    /**
     * The Status.
     * Simulation content status. Supports $filter and $orderby. Possible values are: unknown, draft, ready, archive, delete, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public SimulationContentStatus status;

    /**
     * The Technique.
     * The social engineering technique used in the attack simulation and training campaign. Supports $filter and $orderby. Possible values are: unknown, credentialHarvesting, attachmentMalware, driveByUrl, linkInAttachment, linkToMalwareFile, unknownFutureValue, oAuthConsentGrant. Note that you must use the Prefer: include-unknown-enum-members request header to get the following values from this evolvable enum: oAuthConsentGrant. For more information on the types of social engineering attack techniques, see simulations.
     */
    @SerializedName(value = "technique", alternate = {"Technique"})
    @Expose
	@Nullable
    public SimulationAttackTechnique technique;

    /**
     * The Theme.
     * The theme of a payload. Possible values are: unknown, other, accountActivation, accountVerification, billing, cleanUpMail, controversial, documentReceived, expense, fax, financeReport, incomingMessages, invoice, itemReceived, loginAlert, mailReceived, password, payment, payroll, personalizedOffer, quarantine, remoteWork, reviewMessage, securityUpdate, serviceSuspended, signatureRequired, upgradeMailboxStorage, verifyMailbox, voicemail, advertisement, employeeEngagement, unknownFutureValue.
     */
    @SerializedName(value = "theme", alternate = {"Theme"})
    @Expose
	@Nullable
    public PayloadTheme theme;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
