// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Number Column.
 */
public class NumberColumn implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Decimal Places.
     * How many decimal places to display. See below for information about the possible values.
     */
    @SerializedName(value = "decimalPlaces", alternate = {"DecimalPlaces"})
    @Expose
	@Nullable
    public String decimalPlaces;

    /**
     * The Display As.
     * How the value should be presented in the UX. Must be one of number or percentage. If unspecified, treated as number.
     */
    @SerializedName(value = "displayAs", alternate = {"DisplayAs"})
    @Expose
	@Nullable
    public String displayAs;

    /**
     * The Maximum.
     * The maximum permitted value.
     */
    @SerializedName(value = "maximum", alternate = {"Maximum"})
    @Expose
	@Nullable
    public Double maximum;

    /**
     * The Minimum.
     * The minimum permitted value.
     */
    @SerializedName(value = "minimum", alternate = {"Minimum"})
    @Expose
	@Nullable
    public Double minimum;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
