// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.InstallIntent;
import com.microsoft.graph.models.MobileAppAssignmentSettings;
import com.microsoft.graph.models.DeviceAndAppManagementAssignmentTarget;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Assignment.
 */
public class MobileAppAssignment extends Entity implements IJsonBackedObject {


    /**
     * The Intent.
     * The install intent defined by the admin. Possible values are: available, required, uninstall, availableWithoutEnrollment.
     */
    @SerializedName(value = "intent", alternate = {"Intent"})
    @Expose
	@Nullable
    public InstallIntent intent;

    /**
     * The Settings.
     * The settings for target assignment defined by the admin.
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public MobileAppAssignmentSettings settings;

    /**
     * The Target.
     * The target group assignment defined by the admin.
     */
    @SerializedName(value = "target", alternate = {"Target"})
    @Expose
	@Nullable
    public DeviceAndAppManagementAssignmentTarget target;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
