// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppKeyCredentialRestrictionType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Key Credential Configuration.
 */
public class KeyCredentialConfiguration implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Max Lifetime.
     * 
     */
    @SerializedName(value = "maxLifetime", alternate = {"MaxLifetime"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration maxLifetime;

    /**
     * The Restrict For Apps Created After Date Time.
     * Timestamp when the policy is enforced for all apps created on or after the specified date. For existing applications, the enforcement date would be back dated. To apply to all applications regardless of their creation date, this property would be null. Nullable.
     */
    @SerializedName(value = "restrictForAppsCreatedAfterDateTime", alternate = {"RestrictForAppsCreatedAfterDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime restrictForAppsCreatedAfterDateTime;

    /**
     * The Restriction Type.
     * The type of restriction being applied. Possible values are asymmetricKeyLifetime, unknownFutureValue. Each value of restrictionType can be used only once per policy.
     */
    @SerializedName(value = "restrictionType", alternate = {"RestrictionType"})
    @Expose
	@Nullable
    public AppKeyCredentialRestrictionType restrictionType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
