// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.RetentionLabelSettings;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Retention Label.
 */
public class ItemRetentionLabel extends Entity implements IJsonBackedObject {


    /**
     * The Is Label Applied Explicitly.
     * Specifies whether the label is applied explicitly on the item. True indicates that the label is applied explicitly; otherwise, the label is inherited from its parent. Read-only.
     */
    @SerializedName(value = "isLabelAppliedExplicitly", alternate = {"IsLabelAppliedExplicitly"})
    @Expose
	@Nullable
    public Boolean isLabelAppliedExplicitly;

    /**
     * The Label Applied By.
     * Identity of the user who applied the label. Read-only.
     */
    @SerializedName(value = "labelAppliedBy", alternate = {"LabelAppliedBy"})
    @Expose
	@Nullable
    public IdentitySet labelAppliedBy;

    /**
     * The Label Applied Date Time.
     * The date and time when the label was applied on the item. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Read-only.
     */
    @SerializedName(value = "labelAppliedDateTime", alternate = {"LabelAppliedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime labelAppliedDateTime;

    /**
     * The Name.
     * The retention label on the document. Read-write.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Retention Settings.
     * The retention settings enforced on the item. Read-write.
     */
    @SerializedName(value = "retentionSettings", alternate = {"RetentionSettings"})
    @Expose
	@Nullable
    public RetentionLabelSettings retentionSettings;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
